/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax.devices;

/**
 * Class to test the RTP packet generation.
 */
class RTPTest
{
	public static void main(String[] args)
	{
		// Make an RTP packet factory
		RTPPacketFactory factory = new RTPPacketFactory();
		
		byte[] data = new byte[100];
		byte[] rtpData = null;
		byte[] newData = null;
		
		for(int i=0; i<100; i++)
			data[i] = (byte)i;
		
		while(true)
		{
			// Create a byte array with RTP header
			rtpData = factory.createRTPPacket(data);
			
			// Get an RTP packet from the RTP header + data byte array
			RTPPacket packet = factory.getRTPPacket(rtpData);
			
			// Get the header from the RTP packet
			RTPHeader header = packet.getRTPHeader();
			
			// Use the required fields from the header
			System.out.println("Sequence: " + header.getSequence());
			System.out.println("Time: " + header.getTimeStamp());
			
			// Get the actual data from the packet
			newData = packet.getData();
			
			// Check integrity of the data
			for(int i=0; i<100; i++)
				if(newData[i] != data[i])
					System.out.println("Data not valid");
			
			try
			{
				Thread.sleep(1000);
			}
			catch (InterruptedException e)
			{
			}
		}
	}
}
